using System;
using System.IO;
using System.Xml;
using System.Xml.Xsl;
using System.Xml.XPath;

namespace Borland.Samples{
	/// <summary>
	/// Summary description for Class.
	/// </summary>
	class Transmorgify{

		static public int Transform(XPathDocument xmlInput, XmlTextReader xslTransform, XmlTextWriter Output){
			XslTransform xslt = new XslTransform();
			xslt.Load(xslTransform);
			Output.Formatting=Formatting.Indented;
			xslt.Transform(xmlInput, null, Output);
			return 0;
			}
		static public XmlTextReader getTransform(string FileName){
			XmlTextReader xsltReader;
			if(!File.Exists(FileName))
			  throw(new Exception("Invalid Transform file: " + FileName));
			xsltReader = new XmlTextReader(FileName);
			xsltReader.Read();
			return xsltReader;
			}

		static public XPathDocument getInput(string FileName){
			XPathDocument xpathdocument;
			// if stdin then read
		   //	StreamReader inputStream = new StreamReader(Console.OpenStandardInput());
		   //	if (inputStream.Peek() > -1)
		   //	  xpathdocument = new XPathDocument(inputStream);
		   //	else{
			  if(!File.Exists(FileName))
				throw(new Exception("Invalid Input file: " + FileName));
			  xpathdocument = new XPathDocument(new StreamReader(FileName));
			//  }
			return xpathdocument;
			}
		static public XmlTextWriter getOutput(string FileName){
			XmlTextWriter writer;
			// if FileName null use stdout
			if(FileName==null)
			  writer = new XmlTextWriter(Console.Out);
			else
			  writer = new XmlTextWriter(new StreamWriter(FileName));
			return writer;
			}
		static public void showHelp(){
					// check args
			Console.WriteLine(" transmorgify /I InFile(xml) /T Transform(Filexslt) /O OutFile");
			Console.WriteLine(" about: Applies a transform file to an xml file and dumps");
			Console.WriteLine("        the result to stdout (or outfile with switch).");
			Console.WriteLine("        Input:  xml file as stdin or using /I");
			Console.WriteLine("        Output: stdout or using /O");
			//Console.WriteLine(" -V 	[Option]  Validate (exitcode: 0=valid 1=badxml 2=xslerror)");
			Console.WriteLine("        -I 	[Require] Input File (xml)");
			Console.WriteLine("        -O 	[Option]  Output File (Uses stdout by default)");
			Console.WriteLine("        -T 	[Require] Transform File (xslt)");
			throw new Exception("--End of Help");
		}
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main(string[] args){
		  string InFile="", TransformFile="", OutFile=null;
			try{
				if (args.Length<=1)
				  showHelp();
				if (args.Length>1 && args[0].ToLower() == "-i")
				  InFile=args[1];
				if (args.Length>3 && args[2].ToLower() == "-t")
				  TransformFile=args[3];
				if (args.Length>5 && args[4].ToLower() == "-o")
				  OutFile=args[5];
				XPathDocument input = getInput(InFile);
				XmlTextReader transform = getTransform(TransformFile);
				XmlTextWriter output = getOutput(OutFile);
				Transform(input, transform, output);
				}
			catch(Exception e){
				Console.WriteLine(e.Message);
				}

			}// end Main
		}// end Transmorgify class
	} // end namespace
